/*
 * Decompiled with CFR 0.152.
 */
package jace.hardware;

import jace.hardware.mockingboard.Card;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class AY8910_old {
    static final int MAX_OUTPUT = Short.MAX_VALUE;
    static final int MAX_AY8910 = 2;
    static final int CLOCK = 1789770;
    static final int SAMPLE_RATE = 44100;
    static final int STEP = 32768;
    static int num = 0;
    static int ym_num = 0;
    int SampleRate = 0;
    private List<PSG> chips = new ArrayList<PSG>();
    static int[] VolTable;
    int[][] buffers;
    int bufferLength = -1;

    public AY8910_old() {
        for (int i = 0; i < 2; ++i) {
            PSG chip = new PSG();
            this.chips.add(chip);
        }
        this.initAll(1789770, 44100);
    }

    public void writeReg(int chipNumber, int register, int value) {
        Reg r = Reg.get(register);
        this.writeReg(chipNumber, r, value);
    }

    public void writeReg(int chipNumber, Reg register, int value) {
        this.chips.get(chipNumber).writeReg(register, value);
    }

    public void update(int chipNumber, int[][] buffer, int length) {
        this.chips.get(chipNumber).update(buffer, length);
    }

    public int[][] getBuffers(int length) {
        if (this.buffers == null || this.bufferLength != length) {
            this.buffers = new int[3][length];
            this.bufferLength = length;
        }
        return this.buffers;
    }

    public void playSound(int size, int[] left, int[] right) {
        int[][] buffers = this.getBuffers(left.length);
        this.update(0, buffers, size);
        this.mixDown(left, buffers, size);
        this.update(1, buffers, size);
        this.mixDown(right, buffers, size);
    }

    public void mixDown(int[] out, int[][] in, int size) {
        for (int i = 0; i < size; ++i) {
            int sample;
            out[i] = sample = (in[0][i] + in[1][i] + in[2][i]) / 3;
        }
    }

    public void setClock(int chipNumber, int clock) {
        this.chips.get(chipNumber).setClock(clock);
    }

    public void reset(int chipNumber) {
        this.chips.get(chipNumber).reset();
    }

    public void initAll(int nClock, int nSampleRate) {
        this.SampleRate = nSampleRate;
        for (PSG p : this.chips) {
            p.setClock(nClock);
            p.reset();
        }
    }

    public void initClock(int nClock) {
        for (PSG p : this.chips) {
            p.setClock(nClock);
        }
    }

    static void buildMixerTable() {
        VolTable = new int[32];
        double out = 32767.0;
        for (int i = 31; i > 0; --i) {
            AY8910_old.VolTable[i] = (int)(out + 0.5);
            out /= 1.188502227;
        }
        AY8910_old.VolTable[0] = 0;
    }

    static {
        AY8910_old.buildMixerTable();
    }

    private class PSG {
        int Channel;
        int register_latch;
        Map<Reg, Integer> registers = new HashMap<Reg, Integer>();
        int lastEnable;
        int UpdateStep;
        int PeriodA;
        int PeriodB;
        int PeriodC;
        int PeriodN;
        int PeriodE;
        int CountA;
        int CountB;
        int CountC;
        int CountN;
        int CountE;
        int VolA;
        int VolB;
        int VolC;
        int VolE;
        int EnvelopeA;
        int EnvelopeB;
        int EnvelopeC;
        int OutputA;
        int OutputB;
        int OutputC;
        int OutputN;
        int CountEnv;
        int Hold;
        int Alternate;
        int Attack;
        int Holding;
        int RNG;

        public PSG() {
            for (Reg r : Reg.values()) {
                this.setReg(r, 0);
            }
        }

        public void reset() {
            this.register_latch = 0;
            this.RNG = 1;
            this.OutputA = 0;
            this.OutputB = 0;
            this.OutputC = 0;
            this.OutputN = 255;
            this.lastEnable = -1;
            for (Reg r : Reg.values()) {
                this.writeReg(r, 0);
            }
        }

        public void setClock(int clock) {
            double clk = clock;
            double smprate = AY8910_old.this.SampleRate;
            this.UpdateStep = (int)((32768.0 * smprate * 8.0 + clk / 2.0) / clk);
        }

        public void setReg(Reg r, int value) {
            this.registers.put(r, value);
        }

        public int getReg(Reg r) {
            return this.registers.get((Object)r);
        }

        public void writeReg(Reg r, int value) {
            this.setReg(r, value &= r.max);
            switch (r) {
                case ACoarse: 
                case AFine: {
                    int old = this.PeriodA;
                    this.PeriodA = (this.getReg(Reg.AFine) + 256 * this.getReg(Reg.ACoarse)) * this.UpdateStep;
                    if (this.PeriodA == 0) {
                        this.PeriodA = this.UpdateStep;
                    }
                    this.CountA += this.PeriodA - old;
                    if (this.CountA > 0) break;
                    this.CountA = 1;
                    break;
                }
                case BCoarse: 
                case BFine: {
                    int old = this.PeriodB;
                    this.PeriodB = (this.getReg(Reg.BFine) + 256 * this.getReg(Reg.BCoarse)) * this.UpdateStep;
                    if (this.PeriodB == 0) {
                        this.PeriodB = this.UpdateStep;
                    }
                    this.CountB += this.PeriodB - old;
                    if (this.CountB > 0) break;
                    this.CountB = 1;
                    break;
                }
                case CCoarse: 
                case CFine: {
                    this.setReg(Reg.CCoarse, this.getReg(Reg.CCoarse) & 0xF);
                    int old = this.PeriodC;
                    this.PeriodA = (this.getReg(Reg.CFine) + 256 * this.getReg(Reg.CCoarse)) * this.UpdateStep;
                    if (this.PeriodC == 0) {
                        this.PeriodC = this.UpdateStep;
                    }
                    this.CountC += this.PeriodC - old;
                    if (this.CountC > 0) break;
                    this.CountC = 1;
                    break;
                }
                case NoisePeriod: {
                    int old = this.PeriodN;
                    this.PeriodN = this.getReg(Reg.NoisePeriod) * this.UpdateStep;
                    if (this.PeriodN == 0) {
                        this.PeriodN = this.UpdateStep;
                    }
                    this.CountN += this.PeriodN - old;
                    if (this.CountN > 0) break;
                    this.CountN = 1;
                    break;
                }
                case Enable: {
                    this.lastEnable = value;
                    break;
                }
                case AVol: {
                    this.EnvelopeA = value & 0x10;
                    if (this.EnvelopeA > 0) {
                        this.VolA = this.VolE;
                        break;
                    }
                    if (value > 0) {
                        this.VolA = Card.VolTable[value];
                        break;
                    }
                    this.VolA = Card.VolTable[0];
                    break;
                }
                case BVol: {
                    this.EnvelopeB = value & 0x10;
                    if (this.EnvelopeB > 0) {
                        this.VolB = this.VolE;
                        break;
                    }
                    if (value > 0) {
                        this.VolB = Card.VolTable[value];
                        break;
                    }
                    this.VolB = Card.VolTable[0];
                    break;
                }
                case CVol: {
                    this.EnvelopeC = value & 0x10;
                    if (this.EnvelopeC > 0) {
                        this.VolC = this.VolE;
                        break;
                    }
                    if (value > 0) {
                        this.VolC = Card.VolTable[value];
                        break;
                    }
                    this.VolC = Card.VolTable[0];
                    break;
                }
                case EnvFine: 
                case EnvCoarse: {
                    int old = this.PeriodE;
                    this.PeriodE = (this.getReg(Reg.EnvFine) + 256 * this.getReg(Reg.EnvCoarse)) * this.UpdateStep;
                    if (this.PeriodE == 0) {
                        this.PeriodE = this.UpdateStep / 2;
                    }
                    this.CountE += this.PeriodE - old;
                    if (this.CountE <= 0) {
                        this.CountE = 1;
                    }
                    if (this.PeriodE > 0) break;
                    this.PeriodE = 1;
                    break;
                }
                case EnvShape: {
                    int n = this.Attack = (value & 4) != 0 ? 31 : 0;
                    if ((value & 8) == 0) {
                        this.Hold = 1;
                        this.Alternate = this.Attack;
                    } else {
                        this.Hold = value & 1;
                        this.Alternate = value & 2;
                    }
                    this.CountE = this.PeriodE;
                    this.CountEnv = 31;
                    this.Holding = 0;
                    this.VolE = Card.VolTable[this.CountEnv ^ this.Attack];
                    if (this.EnvelopeA != 0) {
                        this.VolA = this.VolE;
                    }
                    if (this.EnvelopeB != 0) {
                        this.VolB = this.VolE;
                    }
                    if (this.EnvelopeC == 0) break;
                    this.VolC = this.VolE;
                    break;
                }
            }
        }

        void update(int[][] buffer, int length) {
            int[] buf1 = buffer[0];
            int[] buf2 = buffer[1];
            int[] buf3 = buffer[2];
            if ((this.getReg(Reg.Enable) & 1) != 0) {
                if (this.CountA <= length * 32768) {
                    this.CountA += length * 32768;
                }
                this.OutputA = 1;
            } else if (this.getReg(Reg.AVol) == 0 && this.CountA <= length * 32768) {
                this.CountA += length * 32768;
            }
            if ((this.getReg(Reg.Enable) & 2) != 0) {
                if (this.CountB <= length * 32768) {
                    this.CountB += length * 32768;
                }
                this.OutputB = 1;
            } else if (this.getReg(Reg.BVol) == 0 && this.CountB <= length * 32768) {
                this.CountB += length * 32768;
            }
            if ((this.getReg(Reg.Enable) & 4) != 0) {
                if (this.CountC <= length * 32768) {
                    this.CountC += length * 32768;
                }
                this.OutputC = 1;
            } else if (this.getReg(Reg.CVol) == 0 && this.CountC <= length * 32768) {
                this.CountC += length * 32768;
            }
            if ((this.getReg(Reg.Enable) & 0x38) == 56 && this.CountN <= length * 32768) {
                this.CountN += length * 32768;
            }
            int outn = this.OutputN | this.getReg(Reg.Enable);
            int index = 0;
            while (length != 0) {
                int nextevent;
                int volc = 0;
                int volb = 0;
                int vola = 0;
                int left = 32768;
                do {
                    nextevent = this.CountN < left ? this.CountN : left;
                    if ((outn & 8) != 0) {
                        if (this.OutputA != 0) {
                            vola += this.CountA;
                        }
                        this.CountA -= nextevent;
                        while (this.CountA <= 0 && this.PeriodA > 0) {
                            this.CountA += this.PeriodA;
                            if (this.CountA > 0) {
                                this.OutputA ^= 1;
                                if (this.OutputA == 0) break;
                                vola += this.PeriodA;
                                break;
                            }
                            this.CountA += this.PeriodA;
                            vola += this.PeriodA;
                        }
                        if (this.OutputA != 0) {
                            vola -= this.CountA;
                        }
                    } else {
                        this.CountA -= nextevent;
                        while (this.CountA <= 0 && this.PeriodA > 0) {
                            this.CountA += this.PeriodA;
                            if (this.CountA > 0) {
                                this.OutputA ^= 1;
                                break;
                            }
                            this.CountA += this.PeriodA;
                        }
                    }
                    if ((outn & 0x10) != 0) {
                        if (this.OutputB != 0) {
                            volb += this.CountB;
                        }
                        this.CountB -= nextevent;
                        while (this.CountB <= 0 && this.PeriodB > 0) {
                            this.CountB += this.PeriodB;
                            if (this.CountB > 0) {
                                this.OutputB ^= 1;
                                if (this.OutputB == 0) break;
                                volb += this.PeriodB;
                                break;
                            }
                            this.CountB += this.PeriodB;
                            volb += this.PeriodB;
                        }
                        if (this.OutputB != 0) {
                            volb -= this.CountB;
                        }
                    } else {
                        this.CountB -= nextevent;
                        while (this.CountB <= 0 && this.PeriodB > 0) {
                            this.CountB += this.PeriodB;
                            if (this.CountB > 0) {
                                this.OutputB ^= 1;
                                break;
                            }
                            this.CountB += this.PeriodB;
                        }
                    }
                    if ((outn & 0x20) != 0) {
                        if (this.OutputC != 0) {
                            volc += this.CountC;
                        }
                        this.CountC -= nextevent;
                        while (this.CountC <= 0 && this.PeriodC > 0) {
                            this.CountC += this.PeriodC;
                            if (this.CountC > 0) {
                                this.OutputC ^= 1;
                                if (this.OutputC == 0) break;
                                volc += this.PeriodC;
                                break;
                            }
                            this.CountC += this.PeriodC;
                            volc += this.PeriodC;
                        }
                        if (this.OutputC != 0) {
                            volc -= this.CountC;
                        }
                    } else {
                        this.CountC -= nextevent;
                        while (this.CountC <= 0 && this.PeriodC > 0) {
                            this.CountC += this.PeriodC;
                            if (this.CountC > 0) {
                                this.OutputC ^= 1;
                                break;
                            }
                            this.CountC += this.PeriodC;
                        }
                    }
                    this.CountN -= nextevent;
                    if (this.CountN > 0 || this.PeriodN <= 0) continue;
                    if ((this.RNG + 1 & 2) != 0) {
                        this.OutputN ^= 0xFF;
                        outn = this.OutputN | this.getReg(Reg.Enable);
                    }
                    if ((this.RNG & 1) != 0) {
                        this.RNG ^= 0x24000;
                    }
                    this.RNG >>= 1;
                    this.CountN += this.PeriodN;
                } while ((left -= nextevent) > 0);
                if (this.Holding == 0) {
                    this.CountE -= 32768;
                    if (this.CountE <= 0) {
                        do {
                            --this.CountEnv;
                            this.CountE += this.PeriodE;
                        } while (this.CountE <= 0);
                        if (this.CountEnv < 0) {
                            if (this.Hold != 0) {
                                if (this.Alternate != 0) {
                                    this.Attack ^= 0x1F;
                                }
                                this.Holding = 1;
                                this.CountEnv = 0;
                            } else {
                                if (this.Alternate != 0 && (this.CountEnv & 0x20) != 0) {
                                    this.Attack ^= 0x1F;
                                }
                                this.CountEnv &= 0x1F;
                            }
                        }
                        this.VolE = VolTable[this.CountEnv ^ this.Attack];
                        if (this.EnvelopeA != 0) {
                            this.VolA = this.VolE;
                        }
                        if (this.EnvelopeB != 0) {
                            this.VolB = this.VolE;
                        }
                        if (this.EnvelopeC != 0) {
                            this.VolC = this.VolE;
                        }
                    }
                }
                buf1[index] = vola * this.VolA / 32768;
                buf2[index] = volb * this.VolB / 32768;
                buf3[index] = volc * this.VolC / 32768;
                ++index;
                --length;
            }
        }
    }

    public static enum Reg {
        AFine(0, 255),
        ACoarse(1, 15),
        BFine(2, 255),
        BCoarse(3, 15),
        CFine(4, 255),
        CCoarse(5, 15),
        NoisePeriod(6, 31),
        Enable(7, 255),
        AVol(8, 31),
        BVol(9, 31),
        CVol(10, 31),
        EnvFine(11, 255),
        EnvCoarse(12, 255),
        EnvShape(13, 15),
        PortA(14, 255),
        PortB(15, 255);

        public final int registerNumber;
        public final int max;
        public static Reg[] preferredOrder;

        private Reg(int number, int maxValue) {
            this.registerNumber = number;
            this.max = maxValue;
        }

        static Reg get(int number) {
            for (Reg r : Reg.values()) {
                if (r.registerNumber != number) continue;
                return r;
            }
            return null;
        }

        static {
            preferredOrder = new Reg[]{Enable, EnvShape, EnvCoarse, EnvFine, NoisePeriod, AVol, BVol, CVol, AFine, ACoarse, BFine, BCoarse, CFine, CCoarse};
        }
    }
}

